% 3-member 2-dimensional 
% The agents hav velocity actuated point mass dynamics 
% Swarm Tracking, formation control and collision avoidance

clear all; close all;clc;

global M a b c w wx ax cx wy ay cy h k beta wo flag ar;
global vx1save vy1save vx2save vy2save vx3save vy3save tsave;

% obstacle
flag=0;

% disturbance amplitude
ar=0;

% parameter of swarming
M = 3;   % number of vehicle
c=sqrt(3)/1;
a =sqrt(3)*c/3;
%b = 2/5;

% Perturbation based Extremum Seeking parameters
% Vehicle 
wx(1:M) = 200+15*[1:M];            % x-loop perturbation frequency
ax(1:M) = 0.15*ones(1,M);         % x-loop perturbation amplitude
cx(1:M) = 25*ones(1,M);           % x-loop gain

% wx(1:M) = 280+15*[1:M];            % x-loop perturbation frequency
% ax(1:M) = 0.15*ones(1,M);         % x-loop perturbation amplitude
% cx(1:M) = 25*ones(1,M);           % x-loop gain


wy=wx; ay=ax; cy=cx;           % y-loop gain

% filter
h(1:M)=ones(1,M);

% Potential function weight
w=0.2; % weight of the formation
wo=0.5; % weight of the obstacle

% controller gain
k=10;
beta=2;
% Initial Conditions
% xt0= 0*rand(2, 1);
rand('seed',0)
% x0 = [0.05*rand(2,M)-1  xt0 ; zeros(1, M+1)];

x0 = [0.01*rand(2,M)-1 0*rand(2, 1); zeros(1, M+1)];  

% Ode solver
t0 = 0.0;
tf = 50;
tspan = [t0 tf];
tspan = t0:(tf-t0)/100:tf;

myoptions = odeset('OutputFcn','odeplot');
[t, x] = ode23('extremumswarming_derivative', tspan, x0, myoptions);

% position of vehicles
r=length(x);
x1=x(1:r,1);
y1=x(1:r,2);
x2=x(1:r,4);
y2=x(1:r,5);
x3=x(1:r,7);
y3=x(1:r,8);
xt=x(1:r,10);
yt=x(1:r,11);

% Potential Function  
J1t=(1/2)*(((x1-xt).^2+(y1-yt).^2)-a^2).^2;
J2t=(1/2)*(((x2-xt).^2+(y2-yt).^2)-a^2).^2;
J3t=(1/2)*(((x3-xt).^2+(y3-yt).^2)-a^2).^2;
J1a=(1/2)*(((x1-x2).^2+(y1-y2).^2)-c^2).^2+(((x1-x3).^2+(y1-y3).^2)-c^2).^2;
J2a=(1/2)*(((x2-x1).^2+(y2-y1).^2)-c^2).^2+(((x2-x3).^2+(y2-y3).^2)-c^2).^2;
J3a=(1/2)*(((x3-x1).^2+(y3-y1).^2)-c^2).^2+(((x3-x2).^2+(y3-y2).^2)-c^2).^2;

if flag==0
   J=J1t+J2t+J3t+w*(J1a+J2a+J3a)/2;
end

if flag==1
   % Potential function for the obstacle
   obj=[4 6 8 9];

   for ind=1:r     
           xo1=obj(1)-x1(ind);
           xo2=obj(2)-x1(ind);
           yo1=obj(3)-y1(ind);
           yo2=obj(4)-y1(ind);    
           J1o(ind)=abs(xo2.*log(((yo2.^2+xo2.^2).^0.5+yo2)./(((yo2.^2+xo2.^2).^0.5-yo2)))-xo2.*log(((yo1.^2+xo2.^2).^0.5+yo1)/(((yo1.^2+xo2.^2).^0.5-yo1)))...
                   -xo1.*log(((yo2.^2+xo1.^2).^0.5+yo2)/(((yo2.^2+xo1.^2).^0.5-yo2)))+xo1.*log(((yo1.^2+xo1.^2).^0.5+yo1)/(((yo1.^2+xo1.^2).^0.5-yo1))));
   end

   for ind=1:r     
           xo1=obj(1)-x2(ind);
           xo2=obj(2)-x2(ind);
           yo1=obj(3)-y2(ind);
           yo2=obj(4)-y2(ind);    
           J2o(ind)=abs(xo2.*log(((yo2.^2+xo2.^2).^0.5+yo2)./(((yo2.^2+xo2.^2).^0.5-yo2)))-xo2.*log(((yo1.^2+xo2.^2).^0.5+yo1)/(((yo1.^2+xo2.^2).^0.5-yo1)))...
           -xo1.*log(((yo2.^2+xo1.^2).^0.5+yo2)/(((yo2.^2+xo1.^2).^0.5-yo2)))+xo1.*log(((yo1.^2+xo1.^2).^0.5+yo1)/(((yo1.^2+xo1.^2).^0.5-yo1))));
   end

   for ind=1:r     
           xo1=obj(1)-x3(ind);
           xo2=obj(2)-x3(ind);
           yo1=obj(3)-y3(ind);
           yo2=obj(4)-y3(ind);    
           J3o(ind)=abs(xo2.*log(((yo2.^2+xo2.^2).^0.5+yo2)./(((yo2.^2+xo2.^2).^0.5-yo2)))-xo2.*log(((yo1.^2+xo2.^2).^0.5+yo1)/(((yo1.^2+xo2.^2).^0.5-yo1)))...
           -xo1.*log(((yo2.^2+xo1.^2).^0.5+yo2)/(((yo2.^2+xo1.^2).^0.5-yo2)))+xo1.*log(((yo1.^2+xo1.^2).^0.5+yo1)/(((yo1.^2+xo1.^2).^0.5-yo1))));
   end

   J=J1t+J2t+J3t+w*(J1a+J2a+J3a)/2+wo*(J1o+J2o+J3o).';
end

% plot simulation results
% souce seeking, formation control and obstacle avoidance
figure;
plot(x1(1), y1(1), 'o',...
     x2(1), y2(1), 'o',...
     x3(1), y3(1), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
hold on;
plot(xt(1,1), yt(1,1), 'g*',...
    'LineWidth',2 ,'MarkerSize',12); 
plot(x1,y1, '-','LineWidth',2); 
plot(x2,y2, '-','LineWidth',2); 
plot(x3,y3, '-','LineWidth',2); 
plot(xt,yt, 'g-','LineWidth',5); 
plot(xt(r), yt(r),'g*','LineWidth',2,'MarkerSize',12);
plot((x1+x2+x3)./3,(y1+y2+y3)./3,'r-.','LineWidth',3);  
plot(x1(r), y1(r), 'o',...
     x2(r), y2(r), 'o',...
     x3(r), y3(r), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
for i=1:8:r-8,
     plot([x1(i), x2(i)], [y1(i), y2(i)], 'r--','LineWidth',2);
     plot([x2(i), x3(i)], [y2(i), y3(i)], 'r--','LineWidth',2);
     plot([x3(i), x1(i)], [y3(i), y1(i)], 'r--','LineWidth',2);
     plot((x1(i)+x2(i)+x3(i))./3,(y1(i)+y2(i)+y3(i))./3,'p',...
         'MarkerEdgeColor','b','LineWidth',2,...
         'MarkerFaceColor','r','MarkerSize',12);
end;
plot([x1(r), x2(r)], [y1(r), y2(r)], 'r--','LineWidth',3);
plot([x2(r), x3(r)], [y2(r), y3(r)], 'r--','LineWidth',3);
plot([x3(r), x1(r)], [y3(r), y1(r)], 'r--','LineWidth',3);
hold off;
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
title('Swarm Trajectories','FontSize',18,'FontWeight','bold');
grid on

if flag==0
   saveas(gcf,'swarmpath_pbesc.eps','psc2');
end
if flag==1
   patch([4,6,6,4],[8,8,9,9],[1,0,0]);
   saveas(gcf,'swarmpath_pbesc_ob.eps','psc2');
   axis([2 6 4 10]);
   saveas(gcf,'swarmpathzoom_pbesc_ob.eps','psc2');
end

axis tight

% make movie

clear mov;
mov=avifile('movie_swarm_grad_formation.avi','fps',3,'Quality',95,'compression','indeo3');
for f=1:length(t);
clf;

figure(2);
plot(x1(1), y1(1), 'o',...
     x2(1), y2(1), 'o',...
     x3(1), y3(1), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
hold on;
plot(xt(1,1), yt(1,1), 'g*',...
    'LineWidth',2 ,'MarkerSize',12); 
plot(x1(1:f),y1(1:f), '-','LineWidth',2); 
plot(x2(1:f),y2(1:f), '-','LineWidth',2); 
plot(x3(1:f),y3(1:f), '-','LineWidth',2); 
plot(xt(1:f),yt(1:f), 'g-','LineWidth',5); 
plot((x1(1:f)+x2(1:f)+x3(1:f))./3,(y1(1:f)+y2(1:f)+y3(1:f))./3,'r-.','LineWidth',3);  
if f==length(t)
   plot(xt(r), yt(r),'g*','LineWidth',2,'MarkerSize',12);
plot(x1(r), y1(r), 'o',...
     x2(r), y2(r), 'o',...
     x3(r), y3(r), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
   %  plot([x1(r), x2(r)], [y1(r), y2(r)], 'r--','LineWidth',3);
   %  plot([x2(r), x3(r)], [y2(r), y3(r)], 'r--','LineWidth',3);
   %  plot([x3(r), x1(r)], [y3(r), y1(r)], 'r--','LineWidth',3);
end
plot([x1(f), x2(f)], [y1(f), y2(f)], 'r--','LineWidth',2);
plot([x2(f), x3(f)], [y2(f), y3(f)], 'r--','LineWidth',2);
plot([x3(f), x1(f)], [y3(f), y1(f)], 'r--','LineWidth',2);
plot((x1(f)+x2(f)+x3(f))./3,(y1(f)+y2(f)+y3(f))./3,'p',...
         'MarkerEdgeColor','b','LineWidth',2,...
         'MarkerFaceColor','r','MarkerSize',12);
if flag==1
   patch([4,6,6,4],[8,8,9,9],[1,0,0]);
end
hold off;
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
title('Swarm Trajectories','FontSize',18,'FontWeight','bold');
grid on

F=getframe(gcf);
mov=addframe(mov,F)
drawnow;

end;
mov=close(mov);




% center movement
figure;
plot(xt(r-6:r),yt(r-6:r),'g','LineWidth',3);  
hold on
plot((x1(r-6:r)+x2(r-6:r)+x3(r-6:r))./3,(y1(r-6:r)+y2(r-6:r)+y3(r-6:r))./3,'p','MarkerEdgeColor','b','LineWidth',2,...
                'MarkerFaceColor','r',...
                'MarkerSize',12);
plot(x1(r), y1(r), 'o',...
     x2(r), y2(r), 'o',...
     x3(r), y3(r), 'o',...
     'LineWidth',2, 'MarkerEdgeColor','b',...
     'MarkerFaceColor','g',...
     'MarkerSize',12); 
plot([x1(r), x2(r)], [y1(r), y2(r)], 'r--','LineWidth',3);
plot([x2(r), x3(r)], [y2(r), y3(r)], 'r--','LineWidth',3);
plot([x3(r), x1(r)], [y3(r), y1(r)], 'r--','LineWidth',3);
title('Center Trajectory','FontSize',18,'FontWeight','bold');
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
legend('Target Trajectory','Formation Center Trajectory');
axis([11 14 -1 1.5])
%axis([11.5 13.5 -1 1])
grid on
if flag==0
   saveas(gcf,'centerpath_pbesc.eps','psc2');
end
% potential functions
figure,
subplot(1,3,1)
plot(t, J,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J','FontSize',18,'FontWeight','bold');
axis tight
grid;

subplot(1,3,2)
plot(t, J1t,t,J2t,t,J3t,'LineWidth',3); 
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{at}','FontSize',18,'FontWeight','bold');
legend('J_{1t}','J_{2t}','J_{3t}');
axis tight
grid;

subplot(1,3,3)
plot(t, (J1a+J2a+J3a)/2,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{aa}','FontSize',18,'FontWeight','bold');
grid;
axis tight

if flag==0
   saveas(gcf,'J_pbesc.eps','psc2');
end

% potential functions
figure,
subplot(1,4,1)
plot(t, J,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J','FontSize',18,'FontWeight','bold');
axis tight
grid;

subplot(1,4,2)
plot(t, J1t,t,J2t,t,J3t,'LineWidth',3); 
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{at}','FontSize',18,'FontWeight','bold');
legend('J_{1t}','J_{2t}','J_{3t}');
axis tight
grid;

subplot(1,4,3)
plot(t, (J1a+J2a+J3a)/2,'LineWidth',3);  
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{aa}','FontSize',18,'FontWeight','bold');
grid;
axis tight


subplot(1,4,4)
plot(t, J1o,t,J2o,t,J3o,'LineWidth',3); 
xlabel('t','FontSize',18,'FontWeight','bold');
title('J_{ao}','FontSize',18,'FontWeight','bold');
grid;
legend('J_{1o}','J_{2o}','J_{3o}');
axis tight
if flag==1
   saveas(gcf,'J_pbesc_ob.eps','psc2');
end
 





